void Sys_Init() {
  pinMode ( 13 , OUTPUT );
  pinMode ( 24 , OUTPUT );

  pinMode ( 29 , INPUT_PULLUP ); // ADD_B0
  pinMode ( 30 , INPUT_PULLUP ); // ADD_B1
  pinMode ( 31 , INPUT_PULLUP ); // ADD_B2
  pinMode ( 32 , INPUT_PULLUP ); // ADD_B3
  pinMode ( 26 , INPUT_PULLUP ); // ADD_B4

  // initialize serial:
  Serial.begin(115200);
  // reserve 200 bytes for the inputString:
  g_StrInputString.reserve(200);

  g_InputStatus = INPUT_STATUS_IDEL ;
  MsTimer2::set(1, ISR_TIM2_1mS);
  MsTimer2::start();

  Read_and_Check_ModelName(g_ModelNumber);
  g_Hardware_RS485_Add = Read_Add();
}

byte Read_Add() {
  int CoderVal = 31 - ((digitalRead(26) << 4) +
                       (digitalRead(32) << 3) +
                       (digitalRead(31) << 2) +
                       (digitalRead(30) << 1) +
                       digitalRead(29));
  return CoderVal;
}


void WatchdogConfig(int x)
{
  WDTCSR = _BV(WDCE) | _BV(WDE);
  WDTCSR = x;
}

void GoToBoot() //跳转到boot区
{
  noInterrupts();
  WatchdogConfig(0);
  __asm__ __volatile__ (
    "clr r30\n"
    "clr r31\n"
    "ijmp\n" );
}

void Read_and_Check_ModelName(char *ModelNumber) {
  char tmpReadChar ;
  for (int i = 0; i <= 15; i++) {
    tmpReadChar = char(EEPROM.read(1000 + i));
    if (tmpReadChar != ModelNumber[i]) {
      EEPROM.write(1000 + i, ModelNumber[i]);
      delay(2);
    }
    g_Model_Name_Form_Eeprom += char(EEPROM.read(1000 + i));
  }
}
